<?php

#error_reporting(E_ALL & ~E_NOTICE);

require_once 'PHPUnit/Framework.php';
require_once 'PHPUnit/Extensions/PerformanceTestCase.php';

$GLOBALS['vbulletin'] = new StdClass;
$GLOBALS['vbulletin']->db = new StdClass;
define('DIR', dirname(__FILE__) . '/../..');

require_once (DIR . '/includes/class_merge.php');

class diff_merge_Test extends PHPUnit_Extensions_PerformanceTestCase
{
	public function setup() 
	{
	}

	public function teardown() 
	{
	}

	public static function dataMergeTests()
	{
//		return array(
//		array('bfforumdisplay_loggedinuser'),
//		);
		return array(
			array('base'),
			array('deleteagainstdelete'),
			array('deleteagainstedit'),
			array('deleteatends'),
			array('editagainsteditdiff'),
			array('editagainsteditsame'),
			array('insertatends'),
			array('insertagainstinsertsame'),
			array('insertagainstinsertdifferent'),
			array('insertagainstdelete'),
			array('trailingnewline'),
			array('nonewlineatend'),
			array('bfforumdisplay_loggedinuser'),
			
			//adjacent edit tests -- this functionality is not supported but might be
			//in the future. expected results in the non conflict case are provided in an
			//extra non conflict 
			array('deleteadjacenttoedit'),
			array('deleteadjacenttosameedit'),
			array('editadjacent'),
			array('editadjacenttosameedit'),
			array('deleteoverlap'),
			array('deletecontained'),
			array('insertblankagainstblank'),

			//whitespace sensative tests -- as adjacent edits above
			array('deletecontained'),
			array('editagainstblank'),

			//array(''),
		);
	}

	public static function dataLargeTests() 
	{
		return array (
			array("bfshowthread", 4),
			array("bfnavbar", 1),
		);
	}

	public static function dataSvnPort()
	{
		return array(
			array('svn_zig1_zog1_zag1'),
			array('svn_zig2_zog2_zag2'),
			array('svn_zig3a_zog3a_zag3a'),
			array('svn_zig4_zog4_zag4'),
			array('svn_zig6_zog6_zag6'),
			array('svn_splish1_splosh1_splace1'),
			array('svn_splish2_splosh2_splace2'),
			array('svn_splish4_splosh4_splace4'),
			array('svn_dig1_dag1_dug1'),
			array('svn_dig2_dag2_dug2'),
			array('svn_dig3_dag3_dug3'),
		);
	}

	//these are not supported my our diff engine.  We don't want to change the ported
	//svn tests since they are really to define our compatibility with svn so
	//will disable the known failures for now, but leave them here for the future
	//and to document our differences with svn
	public static function dataSvnPortUnsupported()
	{
		return array(
			array('svn_ws_zig1c_zog1c_zag1c'),
			array('svn_ws_zig2c_zog2c_zag2c'),
			array('svn_ws_zig8_zog8_zag8'),
			array('svn_adj1_adj3_adj2'),
		);
	}

	/*
		A few cover functions to allow us to (potentially) articulate
		individual tests in interfaces that allow that.

		Also makes it easier to disable certain tests
	*/

	/**
	* @dataProvider dataMergeTests
	*/
	public function testMerge($prefix)
	{
		return $this->_testMerge($prefix);
	}

	/**
	* @dataProvider dataLargeTests
	*/
	public function testLarge($prefix, $maxtime)
	{
		$this->setMaxRunningTime($maxtime);
		return $this->_testMerge($prefix);
	}


	/**
	* @dataProvider dataSVNPort
	*/
	public function testSVNPort($prefix) {
		return $this->_testMerge($prefix);
	}

	/**
	* @dataProvider dataSVNPortUnsupported
	*/
	public function testSVNPortUnsupported($prefix) {
	//disable for now, we know these don't work and aren't sure we are going to support this
	//return $this->_testMerge($prefix);
	}

	private function _testMerge($prefix) {
		//one-file test format
		if(file_exists(dirname(__FILE__)."/data/$prefix.txt")) {
			$contents = file_get_contents(dirname(__FILE__)."/data/$prefix.txt");
			$contents = preg_split("/##=*##\r?\n/", $contents);
			$this->assertGreaterThanOrEqual(4, (int) count($contents));
			$origin = $contents[0];
			$new = $contents[1];
			$custom = $contents[2];
			$expected = $contents[3];
		}
		//multi file test format
		else {
			$origin = file_get_contents(dirname(__FILE__) . "/data/$prefix-origin.txt");
			$new = file_get_contents(dirname(__FILE__) . "/data/$prefix-new.txt");
			$custom = file_get_contents(dirname(__FILE__) . "/data/$prefix-custom.txt");
			$expected = file_get_contents(dirname(__FILE__) . "/data/$prefix-result.txt");
		}
		
		$this->assertTrue((bool) $origin);
		$merge = new vB_Text_Merge_Threeway($origin, $new, $custom);
		$result = $merge->get_merged();
		$this->assertEquals(
			str_replace("\r\n", "\n", $expected),
			str_replace("\r\n", "\n", $result)
		);
	}
}
?>
